IF OBJECT_ID('tempdb..##LOGINFO_DB') IS NOT NULL
   EXEC ('DROP TABLE ##LOGINFO_DB;');
IF OBJECT_ID('tempdb..##LOGINFO') IS NOT NULL
   EXEC ('DROP TABLE ##LOGINFO;');

DECLARE @SQL NVARCHAR(max);

SET @SQL =
N'CREATE TABLE ##LOGINFO
(' + CASE
-- test le n de version de SQL Server, si 11 (version 2012) ou plus,
-- DBCC LOGINFO contient la colonne RecoveryUnitId
        WHEN CAST(PARSENAME(CAST(SERVERPROPERTY('ProductVersion') AS VARCHAR(32)), 4) AS INT) >= 11
           THEN N'RecoveryUnitId INT,'
        ELSE ''
     END +'
FileId INT,
FileSize BIGINT,
StartOffset BIGINT,
FSeqNo BIGINT,
Status TINYINT,
Parity TINYINT,
CreateLSN nvarchar(255));';

EXEC (@SQL);

SET @SQL = 'SELECT CAST(N'''' AS sysname) AS DB_NAME, * INTO ##LOGINFO_DB FROM ##LOGINFO;';

EXEC (@SQL);

SET @SQL = N'';

SELECT @SQL = @SQL
+ 'INSERT INTO ##LOGINFO EXEC ' + QUOTENAME(name)
+ '.sys.sp_executesql N''DBCC LOGINFO WITH NO_INFOMSGS'';'
+ 'INSERT INTO ##LOGINFO_DB SELECT ''' + name + ''', * FROM ##LOGINFO;'
+ 'TRUNCATE TABLE ##LOGINFO;'
FROM   sys.databases
WHERE  database_id > 4
  AND  state_desc = 'ONLINE'
  AND  source_database_id IS NULL;

EXEC (@SQL);

EXEC ('DROP TABLE ##LOGINFO;')

SELECT * FROM ##LOGINFO_DB;